unit fParam;
    //  John Thomas
    //  1-10-07
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ORCtrls, ORFn, ORNet, Buttons, ComCtrls;

type
  TfrmSpecParam = class(TForm)
    pnl1: TPanel;
    btnSave: TButton;
    btnExit: TBitBtn;
    pcParam: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    lbSurg: TORListBox;
    lblSurg: TLabel;
    btnAdd: TButton;
    btnPos: TButton;
    btnInact: TButton;
    lblAbb: TLabel;
    edAbb: TEdit;
    lblBlock: TLabel;
    lblColor: TLabel;
    ColorBox1: TColorBox;
    lblTitle: TLabel;
    cbTitle: TORComboBox;
    btnColor: TButton;
    lblFac: TLabel;
    lblCare: TLabel;
    cbFac: TORComboBox;
    cbCare: TORComboBox;
    cbCode: TORComboBox;
    pnlSel: TPanel;
    lblSurg1: TLabel;
    cbSurg: TORComboBox;
    rgPos: TRadioGroup;
    btnOK: TButton;
    btnCanc: TButton;
    TabSheet3: TTabSheet;
    lbConsult: TORListBox;
    lblConsult: TLabel;
    pnlCSel: TPanel;
    lblCSel: TLabel;
    cbCSel: TORComboBox;
    btnCCanc: TButton;
    btnCAdd: TButton;
    btnCInac: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure cbTitleClick(Sender: TObject);
    procedure cbSurgClick(Sender: TObject);
    procedure lbSurgClick(Sender: TObject);
    procedure btnInactClick(Sender: TObject);
    procedure cbTitleChange(Sender: TObject);
    procedure ColorBox1Change(Sender: TObject);
    procedure edAbbChange(Sender: TObject);
    procedure lbSurgChange(Sender: TObject);
    procedure btnPosClick(Sender: TObject);
    procedure btnColorClick(Sender: TObject);
    procedure cbSurgChange(Sender: TObject);
    procedure cbFacChange(Sender: TObject);
    procedure cbCareChange(Sender: TObject);
    procedure cbFacClick(Sender: TObject);
    procedure cbCareClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure cbCodeChange(Sender: TObject);
    procedure DisplaySurg;
    procedure HideSurg;
    procedure btnCancClick(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCCancClick(Sender: TObject);
    procedure btnCAddClick(Sender: TObject);
    procedure lbConsultClick(Sender: TObject);
    procedure cbCSelClick(Sender: TObject);
    procedure btnCInacClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmSpecParam: TfrmSpecParam;
  TitleIFN, FacIFN, CareIFN: string;
  Change, Edit, TitleChange, SClick, PosTemp: integer;

procedure EditParam(Spec: integer);

implementation

{$R *.dfm}

uses SCMMain, fColor, rLocal;

procedure EditParam(Spec: integer);
var
  data: string;
begin
  frmSpecParam := TfrmSpecParam.Create(Application);
  with frmSpecParam do
  begin
    Caption := SpecName + ' ' + Caption;
    CallV('APTWL GET TITLES', []);
    cbTitle.Items := RPCBrokerV.Results;
    CallV('APTWL GET PROVIDER', ['G', SpecIFN]);
    cbSurg.Items  := RPCBrokerV.Results;
    CallV('APTWL GET FACILITATORS', [SiteIFN]);
    cbFac.Items   := RPCBrokerV.Results;
    cbCare.Items  := RPCBrokerV.Results;
    CallV('APTWL GET CODES', []);
    cbCode.Items  := RPCBrokerV.Results;
    CallV('APTWL GET REQ SRVC', [SpecName]);
    cbCSel.Items  := RPCBrokerV.Results;
    data := sCallV('APTWL GET SPEC PARAM', [SpecIFN]);
    cbTitle.Text  := piece(piece(data, '^', 1), ':', 2);
    TitleIFN      := piece(piece(data, '^', 1), ':', 1);
    ColorBox1.Selected := clWhite;
    if (piece(data, '^', 2) <> '') then ColorBox1.Selected := StringToColor(piece(data, '^', 2));
    cbCode.Text   := piece(data, '^', 3);
    edAbb.Text    := piece(data, '^', 4);
    cbFac.Text    := piece(piece(data, '^', 5), ':', 2);
    FacIFN        := piece(piece(data, '^', 5), ':', 1);
    cbCare.Text   := piece(piece(data, '^', 6), ':', 2);
    CareIFN       := piece(piece(data, '^', 6), ':', 1);
    CallV('APTWL GET SURGEONS', [SpecIFN]);
    lbSurg.Items := RPCBrokerV.Results;
    CallV('APTWL GET CON SRVC LIST', [SpecIFN]);
    lbConsult.Items  := RPCBrokerV.Results;
    btnInact.Enabled := False;
    btnPos.Enabled   := False;
    btnCInac.Enabled := False;
    Change           := 0;
    Edit             := 0;
    TitleChange      := 0;
    SClick           := 0;
    pcParam.ActivePage := TabSheet1;
    pnl1.Color       := SpecColor;
    ShowModal;
  end;
end;


procedure TfrmSpecParam.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TfrmSpecParam.btnSaveClick(Sender: TObject);
var
  data, title, color, code, abb, fac, care, Success: string;
begin
  if Change = 0 then
  begin
    MessageDlg('No changes have been made.', mtInformation, [mbOK], 0);
    Exit;
  end;
  title := TitleIFN;
  color := ColorToString(ColorBox1.Selected);
  code  := cbCode.Text;
  abb   := edAbb.Text;
  fac   := FacIFN;
  care  := CareIFN;
  data  := title + '^' + color + '^' + code + '^' + abb + '^' + fac + '^' + care;
  Success := sCallV('APTWL PUT SPEC PARAM', [SpecIFN, data, lbSurg.Items, lbConsult.Items]);
  if Success = '0' then MessageDlg('Saving Parameter data was not successful.', mtwarning, [mbOK], 0);
  if Success = '1' then    // update parameters for session
    begin
      SpecAbbr  := edAbb.Text;
      SpecColor := ColorBox1.Selected;
    end;
  Close;
end;

procedure TfrmSpecParam.btnAddClick(Sender: TObject);
begin
  DisplaySurg;
  btnPos.Enabled   := False;
  btnInact.Enabled := False;
  Edit := 0;
end;


procedure TfrmSpecParam.cbTitleClick(Sender: TObject);
begin
  TitleIFN := IntToStr(cbTitle.ItemIEN);
  Change := 1;
end;

procedure TfrmSpecParam.cbSurgClick(Sender: TObject);
begin
  Change          := 1;
  SClick          := 1;
end;

procedure TfrmSpecParam.lbSurgClick(Sender: TObject);
begin
  btnInact.Enabled := True;
  btnPos.Enabled   := True;
end;

procedure TfrmSpecParam.btnInactClick(Sender: TObject);
var
  message: string;
begin
  message := 'Are you sure you want to inactivate ' + piece(lbSurg.Items[lbSurg.ItemIndex], '^', 2) + '?';
  if MessageDlg(message, mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbSurg.Items[lbSurg.ItemIndex] := lbSurg.Items[lbSurg.ItemIndex] + '^Inactive';
  btnInact.Enabled := False;
  Change := 1;
end;

procedure TfrmSpecParam.cbTitleChange(Sender: TObject);
begin
  if cbTitle.Text = '' then Exit;
  CallV('APTWL GET TITLES', [cbTitle.Text]);
  cbTitle.Items := RPCBrokerV.Results;
  TitleChange := 1;
  cbTitle.DroppedDown := True;
end;

procedure TfrmSpecParam.ColorBox1Change(Sender: TObject);
var
  Result: string;
begin
  Change := 1;
  Result := sCallV('APTWL IS COLOR USED', [ColorToString(ColorBox1.Selected)]);
  if piece(Result, '^', 1) = '1' then
    begin
      if MessageDlg('That color is being used by ' + piece(Result, '^', 2), mtwarning, [mbOK, mbIgnore], 0) = mrOK then
        begin
          ColorBox1.Selected := clWhite;
          Change := 0;
          Exit;
        end;
    end;
end;

procedure TfrmSpecParam.edAbbChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.lbSurgChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.btnPosClick(Sender: TObject);
begin
  DisplaySurg;
  cbSurg.Enabled   := False;
  lblSurg1.Enabled := False;
  rgPos.ItemIndex  := StrToInt(piece(lbSurg.Items[lbSurg.ItemIndex], '^', 3)) -1;
  PosTemp          := rgPos.ItemIndex;
  // set check ed item
  Edit             := 1;
  btnAdd.Enabled   := False;
  btnInact.Enabled := False;
end;

procedure TfrmSpecParam.btnColorClick(Sender: TObject);
begin
  ColorGuide;
end;

procedure TfrmSpecParam.cbSurgChange(Sender: TObject);
begin
  if cbSurg.Text = '' then Exit;
  if SClick = 1 then
    begin
      SClick := 0;
      Exit;
    end;
  CallV('APTWL GET PROVIDER', ['G', SpecIFN, cbSurg.Text]);
  cbSurg.Items  := RPCBrokerV.Results;
  cbSurg.DroppedDown := True;
end;

procedure TfrmSpecParam.cbFacChange(Sender: TObject);
begin
  cbFac.DroppedDown := True;
end;

procedure TfrmSpecParam.cbCareChange(Sender: TObject);
begin
  cbCare.DroppedDown := True;
end;

procedure TfrmSpecParam.cbFacClick(Sender: TObject);
begin
  Change := 1;
  FacIFN := IntToStr(cbFac.ItemIEN);
end;

procedure TfrmSpecParam.cbCareClick(Sender: TObject);
begin
  Change  := 1;
  CareIFN := IntToStr(cbCare.ItemIEN);
end;

procedure TfrmSpecParam.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  ResetTimeOut;
end;

procedure TfrmSpecParam.cbCodeChange(Sender: TObject);
begin
  Change := 1;
end;

procedure TfrmSpecParam.DisplaySurg;
begin
  pnlSel.Visible := True;
end;

procedure TfrmSpecParam.HideSurg;
begin
  pnlSel.Visible  := False;
  btnAdd.Enabled  := True;
  btnPos.Enabled  := False;
end;

procedure TfrmSpecParam.btnCancClick(Sender: TObject);
begin
  HideSurg;
end;

procedure TfrmSpecParam.btnOKClick(Sender: TObject);
var
  data, datax: string;
begin
  if Edit = 0 then
    begin
      if cbSurg.Text = '' then
        begin
          HideSurg;
          Exit;
        end;
      data := IntToStr(cbSurg.ItemIEN) + '^' + piece(cbSurg.Items[cbSurg.ItemIndex], '^', 2) + '^' + IntToStr(rgPos.ItemIndex + 1) + '^' + rgPos.Items[rgPos.ItemIndex];
      lbSurg.Items.Add(data);
      cbSurg.Text      := '';
    end
  else
    begin
      if rgPos.ItemIndex = PosTemp then
        begin
          HideSurg;
          Exit;
        end;
      datax := lbSurg.Items[lbSurg.ItemIndex];
      SetPiece(datax, '^', 3, IntToStr(rgPos.ItemIndex + 1));
      SetPiece(datax, '^', 4, rgPos.Items[rgPos.ItemIndex]);
      lbSurg.Items[lbSurg.ItemIndex] := datax;
    end;
  Change := 1;
  HideSurg;
end;

procedure TfrmSpecParam.btnCCancClick(Sender: TObject);
begin
  cbCSel.Text     := '';
  pnlCSel.Visible := False;
end;

procedure TfrmSpecParam.btnCAddClick(Sender: TObject);
begin
  pnlCSel.Visible := True;
end;

procedure TfrmSpecParam.lbConsultClick(Sender: TObject);
begin
  btnCInac.Enabled := True;
end;

procedure TfrmSpecParam.cbCSelClick(Sender: TObject);
var
  data: string;
begin
  data := IntToStr(cbCSel.ItemIEN) + '^' + piece(cbCSel.Items[cbCSel.ItemIndex], '^', 2);
  lbConsult.Items.Add(data);
  cbCSel.Text     := '';
  pnlCSel.Visible := False;
  Change          := 1;
end;

procedure TfrmSpecParam.btnCInacClick(Sender: TObject);
var
  message: string;
begin
  message := 'Are you sure you want to inactivate ' + piece(lbConsult.Items[lbConsult.ItemIndex], '^', 2) + '?';
  if MessageDlg(message, mtConfirmation, [mbYes, mbNo], 0) = mrNo then Exit;
  lbConsult.Items[lbConsult.ItemIndex] := lbConsult.Items[lbConsult.ItemIndex] + '^Inactive';
  btnCInac.Enabled := False;
  Change := 1;
end;

end.
